/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_nic_id_to_hostname.c,v 1.8 2005/06/29 00:23:16 eugene Exp $";

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <netinet/in.h>
#include "mx_auto_config.h"
#include "myriexpress.h"

mx_return_t mx_nic_id_to_hostname(uint64_t nic_id,
				  char *hostname)
{
  struct hostent *host;
  uint32_t addr;

  if (hostname == NULL) {
    return MX_BAD_HOSTNAME_ARGS;
  }

  addr = htonl((uint32_t)nic_id);
  host = gethostbyaddr((char *)&addr, 4, AF_INET);

  if (host==NULL) {
    return MX_HOST_NOT_FOUND;
  }

  hostname[MX_MAX_HOSTNAME_LEN-1] = 0;
  strncpy(hostname,host->h_name, MX_MAX_HOSTNAME_LEN-1);
  
  return MX_SUCCESS;
}

